/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float t=iGlobalTime*1.5;
vec2 hash( vec2 p ) {                       
    p = vec2( dot(p,vec2(127.1,311.7)),
              dot(p,vec2(269.5,183.3)) );
    return -1. + 2.*fract(sin(p+20.)*53758.5453123);
}
float noise( in vec2 p ) {
    vec2 i = floor((p)), f = fract((p));
    vec2 u = f*f*(3.-2.*f);
    return mix( mix( dot( hash( i + vec2(0.,0.) ), f - vec2(0.,0.) ), 
                     dot( hash( i + vec2(1.,0.) ), f - vec2(1.,0.) ), u.x),
                mix( dot( hash( i + vec2(0.,1.) ), f - vec2(0.,1.) ), 
                     dot( hash( i + vec2(1.,1.) ), f - vec2(1.,1.) ), u.x), u.y);
}
void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    float s =noise(uv+t)*14.;
    float b=sin(s-48.*uv.x+t)*sin(s+uv.y*43.-t);
    float g =noise(uv+t-b);
    float uv2= length(uv-.5+g)-sin(b)*sin(.08*t);
    uv2=smoothstep(.49,.5,uv2+g);
	gl_FragColor = vec4(uv2*uv.x-g,g*3.8,uv2,b);  
}
/* 2015 Passion */


